﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Helper;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for DailySalesReport.xaml
    /// </summary>
    public partial class DailySalesReport : Page
    {
        private static DateTime StartTime;
        private static DateTime EndTime;
        private static List<Orders> TotalOrders;
        private static List<Products> TotalProducts;
        private static List<UserAccount> Users;
        private static IEnumerable<dynamic> InventoryReportVal;
        private MasterWindow Master;
        public DailySalesReport()
        {
            InitializeComponent();
            Master = new MasterWindow();
            TotalOrders = new List<Orders>();
            Users = new List<UserAccount>();
            TotalProducts = ProductsBL.GetList(Guid.Empty, string.Empty);
            if (TotalProducts != null && TotalProducts.Count > 0)
            {
                TotalProducts = TotalProducts.Where(a => a.IsActive).ToList<Products>();
            }

            LoadBusinessDay(DateTime.Now);

        }

        private void LoadBusinessDay(DateTime StartDate)
        {
            StartTime = DateTime.Parse(StartDate.ToShortDateString() + " " + AppSession.BusinessHourStart);
            EndTime = DateTime.Parse(StartDate.ToShortDateString() + " " + AppSession.BusinessHourEnd);
            bool EndsNextDay = StartTime > EndTime;
            if (EndsNextDay)
            {
                StartTime = new DateTime(StartDate.Year, StartDate.Month, StartDate.Day, StartTime.Hour, StartTime.Minute, StartTime.Second).AddDays(-1);
                EndTime = new DateTime(StartDate.Year, StartDate.Month, StartDate.Day, StartTime.Hour, StartTime.Minute, StartTime.Second);
            }
            else
            {
                StartTime = new DateTime(StartDate.Year, StartDate.Month, StartDate.Day, StartTime.Hour, StartTime.Minute, StartTime.Second);
                EndTime = new DateTime(StartDate.Year, StartDate.Month, StartDate.Day, StartTime.Hour, StartTime.Minute, StartTime.Second);
            }
            LoadReport(StartTime, EndTime);
            LoadSalesDetails(StartTime);
        }

        private void LoadSalesDetails(DateTime RecordDate)
        {

            Entities.DailySalesReport TodayReport = DailySalesReportBL.GetItem(Guid.Empty, new DateTime(RecordDate.Year, RecordDate.Month, RecordDate.Day, 0, 0, 0));
            if (TodayReport != null)
            {
                txtMoneyIn.Text = TodayReport.MoneyIn.ToString("0.00");
                txtMoneyOut.Text = TodayReport.MoneyOut.ToString("0.00");
                txtActualCashRegisterAmount.Text = TodayReport.CashRegisterBalance.ToString("0.00");
                txtReconcileRemarks.Text = TodayReport.Remarks;

                lblOpeningBalance.Text = TodayReport.OpeningBalance.ToString("0.00");
                lblLedgerAmt.Text = (TodayReport.CashRegisterBalance + TodayReport.ReconcileAmount).ToString();
                lblOpeningBalanceRemarks.Text = TodayReport.OpeningRemarks;
            }
            else
            {
                lblOpeningBalance.Text = "0.00";
                lblLedgerAmt.Text = "0.00";
            }
        }

        private void LoadReport(DateTime StartDate, DateTime EndDate)
        {
            TotalOrders = OrdersBL.GetList(Guid.Empty, Guid.Empty, string.Empty, StartDate, EndDate);
            if (TotalOrders != null && TotalOrders.Count > 0)
            {
                TotalOrders = TotalOrders.Where(a => a.IsActive && a.OrderStatus.ToLower().Equals("delivered")).ToList<Orders>();
            }
            lblDatePeriod.Text = "Sales Report - " + StartDate.ToShortDateString();
            lblSalesTotal.Text = TotalOrders.Sum(a => a.Total).ToString("$ 0.00");
            lblDiscTotal.Text = TotalOrders.Sum(a => a.TotalDiscount + a.Discount + a.HappyHoursDiscount).ToString("$ 0.00");

            List<OrdersPayment> OrdersPaymentList = OrdersPaymentBL.GetList(Guid.Empty, Guid.Empty, StartDate, EndDate);
            if (OrdersPaymentList != null && OrdersPaymentList.Count > 1)
            {
                OrdersPaymentList = OrdersPaymentList.Where(a => TotalOrders.Where(b => b.UniqueID == a.OrdersID).Any()).ToList<OrdersPayment>();
            }

            lblCashValue.Text = OrdersPaymentList.Where(a => a.PaymentMethod.ToLower().Equals("cash")).Sum(a => a.PaidAmount).ToString("$ 0.00");
            lblCreditCardValue.Text = OrdersPaymentList.Where(a => a.PaymentMethod.ToLower().Equals("card")).Sum(a => a.PaidAmount).ToString("$ 0.00");
            lblNetsValue.Text = OrdersPaymentList.Where(a => a.PaymentMethod.ToLower().Equals("nets")).Sum(a => a.PaidAmount).ToString("$ 0.00");

            lblOrderCount.Text = TotalOrders.Count.ToString();
            lblSubmitted.Text = TotalOrders.Where(a => a.OrderStatus.ToLower().Equals("delivered")).Count().ToString();
            lblPending.Text = TotalOrders.Where(a => a.OrderStatus.ToLower().Equals("pending")).Count().ToString();
            lblVoid.Text = TotalOrders.Where(a => a.OrderStatus.ToLower().Equals("canceled")).Count().ToString();

            Users = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            if (Users != null && Users.Count > 0)
            {
                Users = Users.Where(a => a.IsActive).ToList<UserAccount>();
            }
            var UserSales = from a in TotalOrders
                            group a by a.AdminUserAccountID into b
                            select new
                            {
                                UserID = b.Key,
                                UserName = Users.Where(a => a.UniqueID == b.Key).Select(a => a.FirstName).SingleOrDefault(),
                                Sales = TotalOrders.Where(a => a.AdminUserAccountID == b.Key).Sum(a => a.Total)
                            };
            var UserSale = UserSales.FirstOrDefault();
            dgUsers.ItemsSource = UserSales;

            List<Orders> CurrentOrders = TotalOrders.Where(a => a.CreatedDate >= StartDate && a.CreatedDate <= EndDate).ToList<Orders>();
            List<OrdersDetails> OrderDetails = new List<OrdersDetails>();
            CurrentOrders.ForEach(a => OrderDetails.AddRange(a.OrdersDetailsList));
            if (CurrentOrders != null && CurrentOrders.Count > 0)
            {
                var InventoryReport = from a in OrderDetails
                                      where a.ProductID != null && a.ProductID != Guid.Empty
                                      group a by a.ProductID into b
                                      select new
                                      {
                                          ProductName = OrderDetails.Where(c => c.ProductID == b.Key).Select(d => d.ProductName).FirstOrDefault(),
                                          ItemsSold = OrderDetails.Where(c => c.ProductID == b.Key).Sum(d => d.Quantity),
                                          ActualStock = ReturnActualStock(b.Key),
                                          eKey = b.Key

                                      };
                dgInventoryReport.ItemsSource = InventoryReport;
                InventoryReportVal = InventoryReport;
            }
            else
            {
                dgInventoryReport.ItemsSource = null;
                InventoryReportVal = null;
            }

        }

        private int ReturnActualStock(Guid ProductID)
        {
            Products prod = TotalProducts.Where(a => a.UniqueID == ProductID).Single();
            if (prod != null)
                return prod.ActualStock;
            else
                return 0;
        }

        private void btnPrint_Click(object sender, RoutedEventArgs e)
        {
            ReceiptPrintHelper obj = new ReceiptPrintHelper();
            obj.PrintDailyReport(pnlPrintArea);
        }

        private void btnExcel_Click(object sender, RoutedEventArgs e)
        {
            Dictionary<string, string> SalesInfo = new Dictionary<string, string>();
            SalesInfo.Add("Opening Balance", lblOpeningBalance.Text);
            SalesInfo.Add("Cash In", txtMoneyIn.Text);
            SalesInfo.Add("Cash Out", txtMoneyOut.Text);
            SalesInfo.Add("Ledger Amount", lblLedgerAmt.Text);
            SalesInfo.Add("Actual Amount", txtActualCashRegisterAmount.Text);
            SalesInfo.Add("Remarks", txtReconcileRemarks.Text.Replace("\r", "").Replace("\n", ""));
            //ActualAmount, Remarks
            ExcelExportHelper.ExportDailySalesReport(TotalOrders, Users, InventoryReportVal, StartTime, EndTime, SalesInfo);
        }


        private void btnSearch_Click_1(object sender, RoutedEventArgs e)
        {
            DateTime ReportDate = dtReportDate.SelectedDate != null ? dtReportDate.SelectedDate.Value : DateTime.Now;
            ReportDate = ReportDate.AddDays(1);
            LoadBusinessDay(ReportDate);
        }

    }
}
